SWEP.Base					= "kingpin_base"

SWEP.PrintName				= "Flamethrower"
SWEP.Author					= "Nightstalker"
SWEP.Contact				= ""
SWEP.Purpose				= ""
SWEP.Instructions			= ""
SWEP.Category				= "Kingpin"

SWEP.ViewModelFOV			= 90
SWEP.ViewModel				= "models/weapons/v_flamgun.mdl"
SWEP.WorldModel				= "models/w_flamgun.mdl"

SWEP.Spawnable				= true
SWEP.AdminOnly				= false

SWEP.FiresUnderwater		= false
SWEP.Primary.ClipSize		= -1
SWEP.Primary.DefaultClip	= -1
SWEP.Primary.Automatic		= true
SWEP.Primary.Ammo			= "ammo_flameammo"
SWEP.Secondary.ClipSize		= -1
SWEP.Secondary.DefaultClip	= -1
SWEP.Secondary.Automatic	= false
SWEP.Secondary.Ammo			= "None"

SWEP.Attacking = false

game.AddAmmoType({
	name		= "ammo_flameammo",
	dmgtype		= DMG_BULLET,
	tracer		= TRACER_LINE,
	plydmg		= 0,
	npcdmg		= 0,
	force		= 0,
	minsplash	= 0,
	maxsplash	= 0
})

function SWEP:Initialize()
	self:SetWeaponHoldType("physgun")
end

function SWEP:Precache()
	if CLIENT then
		util.PrecacheModel(self.ViewModel)
	end
	util.PrecacheModel(self.WorldModel)
	util.PrecacheSound("v_flamegun/flamepilot.wav")
	for i = 1, 3 do
		util.PrecacheSound("v_flamegun/flame" ..i.. ".wav")
	end
end

function SWEP:Deploy()
	if SERVER then
		self.idlesound = CreateSound(self.Weapon, "v_flamegun/flamepilot.wav")
		self.idlesound:Play()
self.Weapon:SetNextPrimaryFire( CurTime() + 0.5 )
	   self.Weapon:SendWeaponAnim(ACT_VM_DRAW)
	end
	return true
end

function SWEP:Holster()
	if SERVER and self.idlesound then
		self.idlesound:Stop()
	end
	self.Attacking = false
	return true
end

function SWEP:PrimaryAttack()
	local Trace = util.TraceLine({
		start = self:GetOwner():GetShootPos(),
		endpos = self:GetOwner():GetShootPos() + self:GetOwner():GetAimVector() * 250,
		filter = self:GetOwner()
	})
	if self:GetOwner():GetAmmoCount(self.Weapon:GetPrimaryAmmoType()) <= 1 or (Trace.Hit and Trace.Fraction <= 0.1) then
		if self.Attacking then
			self.Attacking = false
			self.Weapon:SendWeaponAnim(ACT_VM_SECONDARYATTACK)
		end
		return
	end
	if not self.Attacking then
		self.Attacking = true
		self.Weapon:SendWeaponAnim(ACT_VM_PRIMARYATTACK)
	end
	self:TakePrimaryAmmo(2)
	self.Weapon:SetNextPrimaryFire(CurTime() + 0.09)
	if SERVER then
		self:GetOwner():EmitSound("v_flamegun/flame" ..math.random(1, 3).. ".wav")
	end
	if SERVER then
		for i = 0, 0.09, 0.03 do
			timer.Simple(i, function()
				if IsValid(self) and IsValid(self.Weapon) and IsValid(self:GetOwner()) and self:GetOwner():Health() > 0 then
					local Origin = Vector(50, -10, -10)
					Origin:Rotate(self:GetOwner():GetAimVector():Angle())
					Origin = self:GetOwner():GetShootPos() + Origin
					local Effect = EffectData()
					Effect:SetOrigin(Origin)
					Effect:SetNormal(self:GetOwner():GetAimVector())
					util.Effect("kp_fire", Effect)
				end
			end)
		end
	end

	if SERVER then
		timer.Simple(Trace.HitPos:Distance(self:GetOwner():GetShootPos()) / 750, function()
			if IsValid(self) and IsValid(self.Weapon) and IsValid(self:GetOwner()) and self:GetOwner():Health() > 0 then
				self:BurnTrace(Trace)
			end
		end)
	end
end

function SWEP:Think()
	if self:GetOwner():KeyReleased(IN_ATTACK) then
		self.Attacking = false
		self.Weapon:SetNextPrimaryFire(self.Weapon:GetNextPrimaryFire() + 0.2)
		self.Weapon:SendWeaponAnim(ACT_VM_SECONDARYATTACK)
		if SERVER then
			self:GetOwner():EmitSound("v_flamegun/flameend.wav")
		end
	end
	if self:GetOwner():GetAmmoCount(self.Primary.Ammo) > 200 then
		self:GetOwner():SetAmmo(200, self.Primary.Ammo)
	end
end